/*
 * Similarity.h
 *
 *  Created on: Nov 28, 2013
 *      Author: nino
 */

#ifndef SIMILARITY_H_
#define SIMILARITY_H_

#include <StandardLibs.h>

#define PHI_JACCARD 0
#define PHI_XNOR 1
#define PHI_RAND 2
#define PHI_NONE 3

double realization_similarity_phi( igraph_vector_t * realization1, igraph_vector_t * realization2, int phi_type, long int num_nodes);

long int realization_XNOR ( igraph_vector_t * realization1, igraph_vector_t * realization2);

double realization_Jaccard ( igraph_vector_t * realization1, igraph_vector_t * realization2);

double rand_sim();

int realization_XNOR_fast ( igraph_vector_t * realization1, igraph_vector_t * realization2);

long int realization_AND ( igraph_vector_t * realization1, igraph_vector_t * realization2);

long int realization_OR ( igraph_vector_t * realization1, igraph_vector_t * realization2);

int realization_identity(igraph_vector_t * realization1, igraph_vector_t * realization2);

double realization_similarity_phi_mask( igraph_vector_t * realization1, igraph_vector_t * realization2, igraph_vector_t * mask ,int phi_type, long int num_nodes);

double realization_Jaccard_mask ( igraph_vector_t * realization1, igraph_vector_t * realization2, igraph_vector_t * mask);

long int realization_AND_mask ( igraph_vector_t * realization1, igraph_vector_t * realization2, igraph_vector_t * mask);

long int realization_OR_mask ( igraph_vector_t * realization1, igraph_vector_t * realization2, igraph_vector_t * mask);

#endif /* SIMILARITY_H_ */
